//
//		Definition of the main game class
//
#ifndef THE_VARIABLE_METER_H
#define THE_VARIABLE_METER_H


#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"

class ldwButton;


class theGameState;
class ldwTextControl;

//CLASS DEFINES
#define cMeterThickness 23
#define cMeterFullWidth 151
#define cOrgMeterFullWidth 320
#define cOrgMeterSliceWidth 8
#define cMeterFrameXOffset 7
#define cMeterFrameYOffset 5
#define cMeterTransparency 0.9f
//...typedefs etc


typedef enum
{
	eRedMeter,
	eGreenMeter,
	eBlueMeter,
	eOrgMeter,
	eNoMeter
} MeterColorEnum;	



//END DEFINES

//BEGIN CLASS DECLARATION
class theVariableMeter 
{
public:

	static theVariableMeter * Get();
	static void Destroy();

	theVariableMeter();
	~theVariableMeter();
	void DrawPercentMeter(MeterColorEnum flavor, int x,int y, int fillPercent);

protected:
	


	static theVariableMeter *mInstance;
private:
    
	ldwGameWindow *gameWindow;
	theGameState  *gs;
	ldwImage *bambooMeterFrame;
	ldwImage *orgMeterSlice;

};
#endif